import { C as ContextDetector } from './ContextDetector-DxzeZq05.js';

const context = ContextDetector.getInstance().detectContext();
if (context === "unknown") {
  const authenticatedView = document.getElementById("authenticated-view");
  const unauthenticatedView = document.getElementById("unauthenticated-view");
  const logoutButton = document.getElementById("logout-button");
  if (unauthenticatedView) {
    unauthenticatedView.classList.remove("hidden");
  }
  const updateAuthUI = (isAuthenticated, showResetView = false) => {
    if (authenticatedView) {
      authenticatedView.classList.toggle("hidden", !isAuthenticated);
    }
    if (unauthenticatedView) {
      unauthenticatedView.classList.toggle("hidden", isAuthenticated);
    }
    if (!showResetView) {
      return;
    }
    const resetView = document.getElementById("reset-view");
    if (resetView) {
      resetView.classList.remove("hidden");
    }
    setTimeout(() => {
      const resetCompleteView = document.getElementById("reset-complete-view");
      if (resetCompleteView) {
        resetCompleteView.classList.remove("hidden");
      }
      if (resetView) {
        resetView.classList.add("hidden");
      }
    }, 3e3);
  };
  chrome.runtime.sendMessage({ type: "GET_AUTH_STATE" }, (response) => {
    if (response && response.isAuthenticated) {
      updateAuthUI(true);
    } else {
      updateAuthUI(false);
    }
  });
  logoutButton?.addEventListener("click", () => {
    chrome.runtime.sendMessage({ type: "LOGOUT" }, (response) => {
      updateAuthUI(false, true);
    });
  });
  chrome.runtime.onMessage.addListener((message) => {
    if (message.type === "AUTH_STATE_CHANGED") {
      updateAuthUI(message.isAuthenticated);
    }
  });
}
//# sourceMappingURL=options.html-BqqITAQ6.js.map
