var ExtensionContext = /* @__PURE__ */ ((ExtensionContext2) => {
  ExtensionContext2["SERVICE_WORKER"] = "service-worker";
  ExtensionContext2["CONTENT_SCRIPT"] = "content-script";
  ExtensionContext2["POPUP"] = "popup";
  ExtensionContext2["OPTIONS"] = "options";
  ExtensionContext2["DEVTOOLS"] = "devtools";
  ExtensionContext2["SIDEBAR"] = "sidebar";
  ExtensionContext2["UNKNOWN"] = "unknown";
  return ExtensionContext2;
})(ExtensionContext || {});
class ContextDetector {
  constructor() {
    this.currentContext = null;
  }
  /**
   * Get the singleton instance of ContextDetector
   */
  static getInstance() {
    if (!ContextDetector.instance) {
      ContextDetector.instance = new ContextDetector();
    }
    return ContextDetector.instance;
  }
  /**
   * Detect the current extension context
   */
  detectContext() {
    if (this.currentContext) {
      return this.currentContext;
    }
    this.currentContext = this.determineContext();
    return this.currentContext;
  }
  /**
   * Check if we're in a specific context
   */
  isContext(context) {
    return this.detectContext() === context;
  }
  /**
   * Get the current context
   */
  getContext() {
    return this.currentContext;
  }
  /**
   * Determine the current extension context
   * @private
   */
  determineContext() {
    if (typeof window === "undefined" && typeof self !== "undefined" && typeof self.importScripts === "function") {
      return "service-worker" /* SERVICE_WORKER */;
    }
    if (typeof chrome !== "undefined" && chrome.devtools && location.href.includes("chrome-extension://")) {
      return "devtools" /* DEVTOOLS */;
    }
    if (typeof document !== "undefined" && typeof chrome !== "undefined" && chrome.runtime && !location.href.includes("chrome-extension://")) {
      return "content-script" /* CONTENT_SCRIPT */;
    }
    if (typeof window !== "undefined" && typeof chrome !== "undefined" && chrome.runtime && chrome.runtime.getManifest && location.href.includes("chrome-extension://")) {
      const manifest = chrome.runtime.getManifest();
      const currentUrl = window.location.href;
      if (manifest.options_page && currentUrl.includes(manifest.options_page)) {
        return "options" /* OPTIONS */;
      }
      if (manifest.sidebar_action && currentUrl.includes("sidebar.html")) {
        return "sidebar" /* SIDEBAR */;
      }
      if (manifest.action?.default_popup && currentUrl.includes("popup.html")) {
        return "popup" /* POPUP */;
      }
    }
    return "unknown" /* UNKNOWN */;
  }
}

export { ContextDetector as C, ExtensionContext as E };
//# sourceMappingURL=ContextDetector-DxzeZq05.js.map
